<?php
// gameapp/teacher_tab_students.php
?>
<section id="tab-students" class="tab-pane">
    <div class="card">
        <h2>Students & Seats</h2>
        <p class="meta">
            Seats used: <strong><?php echo $used_seats; ?></strong> /
            <strong><?php echo $max_students; ?></strong>
            &nbsp;•&nbsp; Empty seats: <strong><?php echo $empty_seats; ?></strong>
        </p>
    </div>

    <div class="card">
        <h3>Create Student</h3>
        <?php if ($empty_seats <= 0): ?>
            <p>You have no empty seats remaining. Contact support to upgrade your plan.</p>
        <?php else: ?>
            <form method="post" class="form-grid">
                <input type="hidden" name="create_student" value="1">
                <label>
                    Student label (name or alias)
                    <input type="text" name="label">
                </label>
                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">Create Student</button>
                </div>
            </form>
        <?php endif; ?>
    </div>

    <div class="card">
        <h3>Your Students</h3>
        <?php if (!$students): ?>
            <p>No students yet.</p>
        <?php else: ?>
            <div class="table-wrapper">
                <table>
                    <thead>
                    <tr>
                        <th>Label</th>
                        <th>Code</th>
                        <th>Game</th>
                        <th>Nation</th>
                        <th>Actions</th>
                        <th>Delete</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($students as $s): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($s['label'] ?? ''); ?></td>
                            <td>
                                <code><?php echo htmlspecialchars($s['student_code']); ?></code><br>
                                <a href="game.php?s=<?php echo urlencode($s['student_code']); ?>" target="_blank">
                                    Open student view
                                </a>
                            </td>
                            <td>
                                <form method="post" class="inline-form">
                                    <input type="hidden" name="student_action" value="assign_game_nation">
                                    <input type="hidden" name="student_id"
                                           value="<?php echo (int)$s['id']; ?>">

                                    <select name="student_game" class="student-game-select">
                                        <option value="0">No game</option>
                                        <?php foreach ($games as $g): ?>
                                            <option value="<?php echo (int)$g['id']; ?>"
                                                <?php if ((int)$s['game_id'] === (int)$g['id']) echo 'selected'; ?>>
                                                <?php echo htmlspecialchars($g['name']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                            </td>
                            <td>
                                    <select name="student_nation" class="student-nation-select">
                                        <option value="0">No nation</option>
                                        <?php
                                        if (!empty($s['game_id']) && isset($game_nations[$s['game_id']])) {
                                            foreach ($game_nations[$s['game_id']] as $n) {
                                                $sel = ((int)$s['nation_id'] === (int)$n['id']) ? 'selected' : '';
                                                echo '<option value="' . (int)$n['id'] . '" ' . $sel . '>' .
                                                     htmlspecialchars($n['name']) . '</option>';
                                            }
                                        }
                                        ?>
                                    </select>
                            </td>
                            <td>
                                    <button type="submit" class="btn btn-small"
                                            onclick="return confirm('Change this student\'s game/nation assignment?');">
                                        Save
                                    </button>
                                </form>
                            </td>
                            <td>
                                <form method="post" class="inline-form"
                                      onsubmit="return confirm('Delete this student and free the seat?');">
                                    <input type="hidden" name="student_action" value="delete">
                                    <input type="hidden" name="student_id"
                                           value="<?php echo (int)$s['id']; ?>">
                                    <button type="submit" class="btn btn-danger btn-small">Delete</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <p class="meta">
                Join URL pattern:
                <code>https://yourdomain.com/gameapp/game.php?s=STUDENTCODE</code>
            </p>
        <?php endif; ?>
    </div>
</section>
