<?php
// gameapp/save_turn.php
require __DIR__ . '/auth.php';
require __DIR__ . '/sim_engine.php';

header('Content-Type: application/json');

$user = require_login();
$pdo  = get_pdo();

$game_id       = (int)($_POST['game_id'] ?? 0);
$state_json_in = $_POST['state_json'] ?? '';
$policies_json_in = $_POST['policies_json'] ?? '';
$run_engine = isset($_POST['run_engine']) && $_POST['run_engine'];

if (!$game_id || $state_json_in === '') {
    http_response_code(400);
    echo json_encode(['error' => 'Missing game_id or state_json']);
    exit;
}

// ensure game belongs to this teacher
$stmt = $pdo->prepare('SELECT id FROM games WHERE id = ? AND teacher_id = ?');
$stmt->execute([$game_id, $user['id']]);
$game = $stmt->fetch();

if (!$game) {
    http_response_code(403);
    echo json_encode(['error' => 'Game not found or not yours']);
    exit;
}

// validate JSON
$state_arr = json_decode($state_json_in, true);
if ($state_arr === null && json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid JSON']);
    exit;
}
$policies_arr = [];
if ($policies_json_in !== '') {
    $policies_arr = json_decode($policies_json_in, true);
    if ($policies_arr === null && json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        echo json_encode(['error' => 'Invalid policies_json']);
        exit;
    }
}

// find next turn number
$stmt = $pdo->prepare('SELECT MAX(turn_number) AS max_turn FROM game_turns WHERE game_id = ?');
$stmt->execute([$game_id]);
$row       = $stmt->fetch();
$next_turn = (int)($row['max_turn'] ?? 0) + 1;

// Apply turn engine if requested. Keep DB turn alignment.
if ($run_engine) {
    $state_arr['turn'] = $next_turn - 1;
    $state_arr = apw_process_turn($state_arr, $policies_arr, apw_engine_overrides());
    $next_turn = (int)($state_arr['turn'] ?? $next_turn);
} else {
    $state_arr['turn'] = $next_turn;
}

// save snapshot
$state_json = json_encode($state_arr);
$stmt = $pdo->prepare(
    'INSERT INTO game_turns (game_id, turn_number, state_json) VALUES (?, ?, ?)'
);
$stmt->execute([$game_id, $next_turn, $state_json]);

// update latest state in games table
$stmt = $pdo->prepare('UPDATE games SET game_state = ? WHERE id = ?');
$stmt->execute([$state_json, $game_id]);

echo json_encode(['ok' => true, 'turn' => $next_turn]);
