<?php
// gameapp/game_tab_trade.php
?>
<section id="game-tab-trade" class="game-tab-pane">
    <div class="card">
        <h2>Trade</h2>
        <?php if (!empty($apw_nation_state)): ?>
            <?php $ns = $apw_nation_state; ?>
            <div class="stat-grid">
                <div class="stat">
                    <div class="label">Food Surplus</div>
                    <div class="value"><?php echo number_format((float)($ns['food_surplus'] ?? 0), 1); ?></div>
                </div>
                <div class="stat">
                    <div class="label">Energy Surplus</div>
                    <div class="value"><?php echo number_format((float)($ns['energy_surplus'] ?? 0), 1); ?></div>
                </div>
                <div class="stat">
                    <div class="label">Goods Output</div>
                    <div class="value"><?php echo number_format((float)($ns['goods_output'] ?? 0), 1); ?></div>
                </div>
                <div class="stat">
                    <div class="label">Services Output</div>
                    <div class="value"><?php echo number_format((float)($ns['services_output'] ?? 0), 1); ?></div>
                </div>
                <div class="stat">
                    <div class="label">Heavy Output</div>
                    <div class="value"><?php echo number_format((float)($ns['heavy_output'] ?? 0), 1); ?></div>
                </div>
            </div>
            <p class="meta">Global prices, tariffs, and trade partners are not yet captured here. Surpluses/outputs hint at what you can export or need to import.</p>
        <?php else: ?>
            <p>Trade stats will appear after the first processed turn.</p>
        <?php endif; ?>
    </div>
</section>
