<?php
// gameapp/game_tab_military.php
?>
<section id="game-tab-military" class="game-tab-pane">
    <div class="card">
        <h2>Military</h2>
        <?php if (!empty($apw_nation_state)): ?>
            <?php $ns = $apw_nation_state; ?>
            <div class="stat-grid">
                <div class="stat">
                    <div class="label">Ground Manpower</div>
                    <div class="value"><?php echo number_format((float)($ns['ground_forces']['manpower'] ?? 0), 1); ?></div>
                </div>
                <div class="stat">
                    <div class="label">Ground Readiness</div>
                    <div class="value"><?php echo number_format((float)($ns['ground_forces']['readiness'] ?? 0), 1); ?> / 100</div>
                </div>
                <div class="stat">
                    <div class="label">Ground Combat Power</div>
                    <div class="value"><?php echo number_format((float)($ns['combat_power']['ground'] ?? 0), 1); ?></div>
                </div>
                <div class="stat">
                    <div class="label">Air Manpower</div>
                    <div class="value"><?php echo number_format((float)($ns['air_forces']['manpower'] ?? 0), 1); ?></div>
                </div>
                <div class="stat">
                    <div class="label">Air Readiness</div>
                    <div class="value"><?php echo number_format((float)($ns['air_forces']['readiness'] ?? 0), 1); ?> / 100</div>
                </div>
                <div class="stat">
                    <div class="label">Air Combat Power</div>
                    <div class="value"><?php echo number_format((float)($ns['combat_power']['air'] ?? 0), 1); ?></div>
                </div>
                <div class="stat">
                    <div class="label">Naval Manpower</div>
                    <div class="value"><?php echo number_format((float)($ns['naval_forces']['manpower'] ?? 0), 1); ?></div>
                </div>
                <div class="stat">
                    <div class="label">Naval Readiness</div>
                    <div class="value"><?php echo number_format((float)($ns['naval_forces']['readiness'] ?? 0), 1); ?> / 100</div>
                </div>
                <div class="stat">
                    <div class="label">Naval Combat Power</div>
                    <div class="value"><?php echo number_format((float)($ns['combat_power']['naval'] ?? 0), 1); ?></div>
                </div>
                <div class="stat">
                    <div class="label">Population Loyalty</div>
                    <div class="value"><?php echo number_format((float)($ns['population_loyalty'] ?? 0), 2); ?> (0–1)</div>
                </div>
                <div class="stat">
                    <div class="label">Military Cost (per turn)</div>
                    <div class="value"><?php echo number_format((float)($ns['military_cost'] ?? 0), 2); ?></div>
                </div>
            </div>
        <?php else: ?>
            <p>Military stats will appear after the first processed turn.</p>
        <?php endif; ?>
    </div>
</section>
