<?php
// gameapp/game_tab_map.php
require_once __DIR__ . '/world_map.php';

$map_options = [
    'game_id'          => $game_id,
    'map_type'         => $data['map_type'] ?? 'standard',
    'map_size'         => $data['map_size'] ?? 'medium',
    'inequality_level' => $data['inequality_level'] ?? 'medium',
    'land_sea_pattern' => $data['land_sea_pattern'] ?? 'balanced',
    'preset_map'       => $data['preset_map'] ?? '',
];
$game_map = apw_generate_world_map($map_options);
?>
<div id="tab-map" class="game-tab-pane">
    <div class="card">
        <h2>Map</h2>
        <p class="meta">
            Generated from game settings (<?php echo htmlspecialchars($map_options['map_type']); ?>,
            <?php echo htmlspecialchars($map_options['map_size']); ?>).
        </p>
        <?php echo apw_render_map_html($game_map); ?>
        <p class="meta">
            Seed: <code><?php echo htmlspecialchars($game_map['seed']); ?></code> ·
            Tiles: <?php echo (int)$game_map['width']; ?> × <?php echo (int)$game_map['height']; ?> ·
            Land/sea: <?php echo htmlspecialchars($map_options['land_sea_pattern']); ?>
        </p>
    </div>
</div>
