<?php
// gameapp/game_tab_government.php
?>
<section id="game-tab-government" class="game-tab-pane active">
    <div class="card">
        <h2>Government & Nation Overview</h2>
        <?php if ($nation_id === 0): ?>
            <p>You are in the game, but not assigned to a nation yet. Talk to your teacher.</p>
        <?php else: ?>
            <div class="gov-grid">
                <div>
                    <table class="gov-meta-table">
                        <tr>
                            <th>Nation</th>
                            <td><?php echo htmlspecialchars($gov_data['nation_name'] ?? 'Unknown'); ?></td>
                        </tr>
                        <tr>
                            <th>Political system</th>
                            <td><?php echo htmlspecialchars($gov_data['political_name'] ?? '—'); ?></td>
                        </tr>
                        <tr>
                            <th>Economic system</th>
                            <td><?php echo htmlspecialchars($gov_data['economic_name'] ?? '—'); ?></td>
                        </tr>
                        <tr>
                            <th>Media freedom</th>
                            <td><?php echo htmlspecialchars($gov_data['media_name'] ?? '—'); ?></td>
                        </tr>
                        <tr>
                            <th>Game inequality index</th>
                            <td><?php echo htmlspecialchars($gov_data['inequality_level'] ?? 'medium'); ?></td>
                        </tr>
                        <tr>
                            <th>Map type / size</th>
                            <td>
                                <?php echo htmlspecialchars($gov_data['map_type']); ?>
                                /
                                <?php echo htmlspecialchars($gov_data['map_size']); ?>
                            </td>
                        </tr>
                        <tr>
                            <th>Land/sea pattern</th>
                            <td><?php echo htmlspecialchars($gov_data['land_sea_pattern']); ?></td>
                        </tr>
                        <tr>
                            <th>Preset map</th>
                            <td><?php echo htmlspecialchars($gov_data['preset_map'] ?? 'Procedural'); ?></td>
                        </tr>
                    </table>

                    <h3>Government team & roles</h3>
                    <?php if (!$gov_teammates): ?>
                        <p>No team members found yet. You might be the first one here.</p>
                    <?php else: ?>
                        <table class="team-table">
                            <thead>
                            <tr>
                                <th>Player</th>
                                <th>Role</th>
                                <th>Abilities (raw)</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($gov_teammates as $tm): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($tm['student_label'] ?? 'Student'); ?></td>
                                    <td><?php echo htmlspecialchars($tm['role_label'] ?? 'Member'); ?></td>
                                    <td>
                                        <?php
                                        if (!empty($tm['privileges_json'])) {
                                            $pj = json_decode($tm['privileges_json'], true);
                                            if (is_array($pj)) {
                                                echo htmlspecialchars(implode(', ', array_keys($pj)));
                                            } else {
                                                echo htmlspecialchars($tm['privileges_json']);
                                            }
                                        } else {
                                            echo '—';
                                        }
                                        ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                        <p class="meta">
                            (Future versions will use these abilities to unlock editing in specific tabs,
                            or require leader approval / majority votes.)
                        </p>
                    <?php endif; ?>
                </div>

                <div>
                    <h3>Flag & identity</h3>
                    <div class="flag-preview-large">
                        <div class="flag-preview-stripes"
                             data-primary="<?php echo htmlspecialchars($gov_primary); ?>"
                             data-secondary="<?php echo htmlspecialchars($gov_secondary ?? ''); ?>"
                             data-stripe="<?php echo htmlspecialchars($gov_stripe); ?>"
                             data-fraction="<?php echo htmlspecialchars($gov_width_f); ?>"
                             style="background: <?php echo htmlspecialchars($gov_primary); ?>;">
                        </div>
                    </div>
                    <p class="meta">
                        Your nation’s flag uses a primary color
                        <?php echo htmlspecialchars($gov_primary); ?>
                        <?php if ($gov_secondary && $gov_stripe !== 'none'): ?>
                            and secondary color <?php echo htmlspecialchars($gov_secondary); ?> with
                            <?php echo htmlspecialchars($gov_stripe); ?> stripes
                            (width <?php echo htmlspecialchars($gov_width_f); ?> of the flag).
                        <?php else: ?>
                            with no stripes.
                        <?php endif; ?>
                    </p>
                </div>
            </div>
        <?php endif; ?>
    </div>
</section>
