<?php
// gameapp/game_tab_economy.php
?>
<section id="game-tab-economy" class="game-tab-pane">
    <div class="card">
        <h2>Economy</h2>
        <?php if (!empty($apw_nation_state)): ?>
            <?php
            $ns = $apw_nation_state;
            $food_surplus = ($ns['food_surplus'] ?? 0);
            $energy_surplus = ($ns['energy_surplus'] ?? 0);
            $econ_balance = ($ns['econ_balance'] ?? 0);
            ?>
            <div class="stat-grid">
                <div class="stat">
                    <div class="label">Goods Output</div>
                    <div class="value"><?php echo number_format((float)($ns['goods_output'] ?? 0), 1); ?></div>
                </div>
                <div class="stat">
                    <div class="label">Services Output</div>
                    <div class="value"><?php echo number_format((float)($ns['services_output'] ?? 0), 1); ?></div>
                </div>
                <div class="stat">
                    <div class="label">Heavy Output</div>
                    <div class="value"><?php echo number_format((float)($ns['heavy_output'] ?? 0), 1); ?></div>
                </div>
                <div class="stat">
                    <div class="label">Food Surplus</div>
                    <div class="value"><?php echo number_format($food_surplus, 1); ?></div>
                </div>
                <div class="stat">
                    <div class="label">Energy Surplus</div>
                    <div class="value"><?php echo number_format($energy_surplus, 1); ?></div>
                </div>
                <div class="stat">
                    <div class="label">Economic Balance</div>
                    <div class="value"><?php echo number_format($econ_balance, 1); ?></div>
                </div>
                <div class="stat">
                    <div class="label">Standard of Living</div>
                    <div class="value"><?php echo number_format((float)($ns['standard_of_living'] ?? 0), 1); ?> / 100</div>
                </div>
                <div class="stat">
                    <div class="label">Education Index</div>
                    <div class="value"><?php echo number_format((float)($ns['education_index'] ?? 0), 1); ?> / 100</div>
                </div>
                <div class="stat">
                    <div class="label">Corruption</div>
                    <div class="value"><?php echo number_format((float)($ns['corruption_index'] ?? 0), 1); ?> / 100</div>
                </div>
            </div>
        <?php else: ?>
            <p>No turn data yet. Once the first turn is processed, economic stats will appear here.</p>
        <?php endif; ?>
    </div>
</section>
