<?php
// Utility page to create an additional teacher account.
require __DIR__ . '/config.php';

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $account_type_id = !empty($_POST['account_type_id']) ? (int)$_POST['account_type_id'] : null;

    if ($email === '' || $password === '') {
        $error = 'Email and password are required.';
    } else {
        try {
            $pdo = get_pdo();
            $stmt = $pdo->prepare('SELECT id FROM users WHERE email = ?');
            $stmt->execute([$email]);
            if ($stmt->fetch()) {
                $error = 'A user with that email already exists.';
            } else {
                $hash = password_hash($password, PASSWORD_DEFAULT);
                $stmt = $pdo->prepare(
                    'INSERT INTO users (email, password_hash, account_type_id, created_at) VALUES (?, ?, ?, NOW())'
                );
                $stmt->execute([$email, $hash, $account_type_id]);
                $message = 'Teacher account created for ' . htmlspecialchars($email);
            }
        } catch (Exception $e) {
            $error = 'Unable to create account: ' . $e->getMessage();
        }
    }
}
?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title>Create Teacher Account</title>
</head>
<body>
    <h1>Create Teacher Account</h1>
    <?php if ($message): ?>
        <p style="color:green;"><?php echo $message; ?></p>
    <?php endif; ?>
    <?php if ($error): ?>
        <p style="color:red;"><?php echo htmlspecialchars($error); ?></p>
    <?php endif; ?>
    <form method="post">
        <p>
            <label>Email<br>
                <input type="email" name="email" required>
            </label>
        </p>
        <p>
            <label>Password<br>
                <input type="password" name="password" required>
            </label>
        </p>
        <p>
            <label>Account type ID (optional)<br>
                <input type="number" name="account_type_id" min="1" placeholder="Leave blank for default">
            </label>
        </p>
        <p><button type="submit">Create teacher</button></p>
    </form>
</body>
</html>
