<?php
// gameapp/api_game_overview.php

require __DIR__ . '/auth.php';

header('Content-Type: application/json');

$user = require_login();
$pdo  = get_pdo();

$game_id = (int)($_GET['game_id'] ?? 0);
if (!$game_id) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing game_id']);
    exit;
}

// Ensure game belongs to this teacher
$stmt = $pdo->prepare(
    'SELECT * FROM games WHERE id = ? AND teacher_id = ?'
);
$stmt->execute([$game_id, $user['id']]);
$game = $stmt->fetch();

if (!$game) {
    http_response_code(403);
    echo json_encode(['error' => 'Game not found or not yours']);
    exit;
}

// Nations in this game
$stmt = $pdo->prepare(
    'SELECT n.*, ps.name AS political_name, es.name AS economic_name
     FROM nations n
     LEFT JOIN political_systems ps ON n.political_system_id = ps.id
     LEFT JOIN economic_systems es ON n.economic_system_id = es.id
     WHERE n.game_id = ?
     ORDER BY n.id ASC'
);
$stmt->execute([$game_id]);
$nations = $stmt->fetchAll();

// Students in this game
$stmt = $pdo->prepare(
    'SELECT s.*
     FROM students s
     WHERE s.game_id = ?
     ORDER BY s.created_at ASC'
);
$stmt->execute([$game_id]);
$students = $stmt->fetchAll();

// Nation memberships
$stmt = $pdo->prepare(
    'SELECT nm.*, n.name AS nation_name, s.label AS student_label, s.student_code
     FROM nation_members nm
     JOIN nations n ON nm.nation_id = n.id
     JOIN students s ON nm.student_id = s.id
     WHERE n.game_id = ?
     ORDER BY n.id, nm.created_at'
);
$stmt->execute([$game_id]);
$memberships = $stmt->fetchAll();

// Basic turn metrics
$stmt = $pdo->prepare(
    'SELECT COUNT(*) AS total_turns,
            MIN(created_at) AS first_turn_at,
            MAX(created_at) AS last_turn_at
     FROM game_turns
     WHERE game_id = ?'
);
$stmt->execute([$game_id]);
$metrics = $stmt->fetch() ?: [
    'total_turns'   => 0,
    'first_turn_at' => null,
    'last_turn_at'  => null,
];

echo json_encode([
    'game'        => $game,
    'nations'     => $nations,
    'students'    => $students,
    'memberships' => $memberships,
    'turn_metrics'=> $metrics,
]);
