# Turn Engine (Prototype)

This repo now ships with `sim_engine.php`, a deterministic per-turn rules engine that matches the “A Possible World” specification (tile food/energy/industry/environment/population, nation indices, policies, military, corruption/media, government modifiers).

## Usage

```php
require __DIR__ . '/sim_engine.php';

$state = [
    'turn' => 0,
    'tiles' => [
        [
            'id' => 1,
            'nation_id' => 101,
            'terrain' => 'plains',
            'biome' => 'plains',
            'tile_area' => 1,
            'population' => 2.5,
            'density' => 0,
            'food_production' => 20,
            'food_need' => 0,
            'renewable_cap' => 30,
            'renewable_use' => 10,
            'fossil_reserves' => 50,
            'fossil_extraction' => 0,
            'industry_goods' => 5,
            'industry_services' => 2,
            'industry_heavy' => 1,
            'environment' => 70,
            'pollution' => 10,
            'infrastructure' => 40,
            'forest_reserves' => 10,
            'mineral_reserves' => 15,
        ],
    ],
    'nations' => [
        [
            'id' => 101,
            'gov_type' => 'democracy',
            'education_index' => 30,
            'corruption_index' => 20,
            'media_freedom' => 60,
            'population_loyalty' => 0.6,
            'tech_agriculture' => 1,
            'tech_industry' => 1,
            'tech_energy' => 1,
            'tech_infrastructure' => 1,
            'tech_medicine' => 0,
            'tech_military_ground' => 0,
            'tech_military_air' => 0,
            'tech_military_naval' => 0,
            'ground_forces' => ['manpower' => 0, 'equipment_score' => 0, 'readiness' => 0, 'status' => 'stationed'],
            'air_forces' => ['manpower' => 0, 'equipment_score' => 0, 'readiness' => 0, 'status' => 'stationed'],
            'naval_forces' => ['manpower' => 0, 'equipment_score' => 0, 'readiness' => 0, 'status' => 'stationed'],
        ],
    ],
];

$policies = [
    101 => [
        'agriculture' => 0.1,
        'green_energy' => 0.1,
        'fossil_energy' => 0.05,
        'infrastructure' => 0.1,
        'environmental_protection' => 0.05,
        'social_spending' => 0.1,
        'education' => 0.1,
        'anti_corruption' => 0.05,
        'media_support' => 0.05,
        'industry_goods' => 0.1,
        'industry_services' => 0.1,
        'industry_heavy' => 0.1,
        'military_ground' => 0.02,
        'military_air' => 0.01,
        'military_naval' => 0.01,
        'recruitment_policy' => 0.2,
        'readiness_spending' => 0.2,
        'loyalty_programs' => 0.1,
    ],
];

$next_state = apw_process_turn($state, $policies);
```

## Notes
- Policies are automatically normalised if they sum to more than 1.0.
- Government modifiers, corruption penalties, and efficiency multipliers are baked into the investment step.
- Clamp rules (0–100 where appropriate) ensure stability; constants are configurable via `apw_default_engine_config()` override.
- Turn order: aggregate → budget/investment → tiles → military → re-aggregate → indices (SoL, education, corruption, media, happiness) → government caps → summary.
